/**
 * @author student
/*******************************************************************************
 * Copyright (c) 2003 Clearfield Knowledge Solutions.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.k.co.nz/
 *******************************************************************************/
/* * 
 * Copyright: Copyright (c) 2003
 * Company  : Clearfield Knowledge Solutions
 * @author  : Student
 * @version : 1.0
 * Date Created : Jul 8, 2003
 * Title : Validators.CreditCardValidator.java
 * Desprition : This Validators class is responsible for checking and validating the 
 * Customer Credit card Information
 * 
 */
package Validators;

import JavaBeans.*;
/**
 * @author student
 *
 * This class is being used for validation of credit card data.
 * 
 */
public class CreditCardValidator {

	private String message;


	/**
	 * This method is being used for getting an error message if the 
	 * validation was unsuccessful.
	 * @return String The message to be displayed.
	 */
	public String getMessage() {
		return message;
	}
	
	/**
	 * This method is being used for setting an error message if the
	 * validation is unsuccessful.
	 * @param message The message to be displayed.
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	
	/**
	 * This method is being used for validation of a given creditcard
	 * data.
	 * @param creditCardData The credit card data details to be validated.
	 * @return boolean Specifies whether the validation was successful.
	 */
	public boolean validate(CreditCard_Data creditCardData) {

		CreditCard_Data creditcarddata = creditCardData;
		String cardType, cardHolderName, expiryDate;
		String cardNumber;

		cardType = creditcarddata.getCardType();
		cardHolderName = creditcarddata.getCardHolderName();
		cardNumber = creditcarddata.getCardNumber();
		expiryDate = creditcarddata.getExpiryDate();

//		System.out.println("Validate: cardType " + cardType);
//		System.out.println("Validate: cardHolderName " + cardHolderName);
//		System.out.println("Validate: cardNumber " + cardNumber);
//		System.out.println("Validate: cardExpiryDate " + expiryDate);

		//check card type.
		if (cardType == null
			|| cardHolderName == null
			|| expiryDate == null
			|| cardNumber == null) {
			message = "Some of the required credit card details are empty.";
			return false;
		}
		if (!cardType.matches("^[a-zA-Z/(/)0-9/ ///,/./-]+$")) {
			message = "Please select your credit card company.";
			return false;
		}
		//check card holder name.
		if (!cardHolderName.matches("^[a-zA-Z/(/)/'/-/0-9/ ///,/./-]+$")) {
			message = "Card Holder name has invalid characters.";
			return false;
		}
		//check expiry date.
		if (!expiryDate.matches("^[0-9]{4}+$")) {
			message = "Expiry Date has invalid characters.";
			message += " The date, month, and year should be digits. ";
			return false;
		}
		//check card number.
		if (!cardNumber.matches("^[0-9]{10,16}+$")) {
			message = "Card number has invalid characters.";
			message
				+= " Only 10-16 digits are allowed. All other characters are not allowed";
			return false;
		}
		return true;
	}

}
